#if !defined(ABILITYCASH_EXPORT_AND_IMPORT_INTERFACES_HEADER)
#define ABILITYCASH_EXPORT_AND_IMPORT_INTERFACES_HEADER

// -------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------

//          
// ( - plugins)    AbilityCash.
//
//     ( )  ,   
//   AbilityCash.exe    dll-,   
// .  dll-        
//    GetExportInterfaceCount  GetImportInterfaceCount (
//     ).       
//  0,   dll-   .
//
//   dll-    ( ), AbilityCash 
//        GetExportInterface (
// GetImportInterface   ),      zero-
// based    .
//
//    AbilityCash   /    xml.

// -------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------

namespace ExportImport {

	// ---------------------------------------------------------------------------------------------
	// --- ASequentialStream -----------------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------
	//  ASequentialStream          
	//  xml-  AbilityCash     .   
	//     /   AbilityCash  .
	struct ASequentialStream : ISequentialStream {

		// ---    :

		// - QueryInterface     -      , 
		//                         ISequentialStream  IUnknown.    
		//                          E_NOTIMPL.
		// - AddRef, Release    -    IUnknown.
		// - Read, Write        - .   ISequentialStream.

		// - GetStreamSize      -   ,   streamSize  
		//                             S_OK.
		//                               
		//                         .
		virtual HRESULT STDMETHODCALLTYPE GetStreamSize (LPDWORD streamSize) = 0;

		// - GetCurrentPosition -   ,   currentPosition 
		//                              
		//                            S_OK.
		//                               
		//                         .
		virtual HRESULT STDMETHODCALLTYPE GetCurrentPosition (LPDWORD currentPosition) = 0;

	}; // struct ASequentialStream

	// ---------------------------------------------------------------------------------------------
	// --- APluginTools ----------------------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------
	//  APluginTools   AbilityCash    / 
	//    /.      .
	struct APluginTools {

		/* ---   / -------------------------------------------------

		   GetLocalizedString          
		   ,        
		    . */

		virtual LPCWSTR STDMETHODCALLTYPE GetLocalizedString (LPCWSTR) = 0;

		/* ---      -------------------------------------------------

		    ,        
		    . AbilityCash ,  ,   
		     (dll)      .  ,
		            .

		           dll-
		   . ,       "Mode",  
		          "mylib-exim:Mode",  mylib
		       "mylib.dll".

		    ,        
		    .        ( 
		   ),     ,         
		   .

		          ,  
		   HKCU/Software/AbilitySoft/AbilityCash    ,   
		   AbilityCash.ini,      . */

		virtual bool STDMETHODCALLTYPE SaveConfigString (LPCWSTR settingName, LPCWSTR settingValue) = 0;
		virtual bool STDMETHODCALLTYPE SaveConfigInt (LPCWSTR settingName, DWORD settingValue) = 0;
		virtual bool STDMETHODCALLTYPE LoadConfigString (LPCWSTR settingName, LPWSTR settingBuffer, UINT bufSizeInChars) = 0;
		virtual bool STDMETHODCALLTYPE LoadConfigInt (LPCWSTR settingName, DWORD & settingValue) = 0;

		/* ---   / ---------------------------------------------------

		    ,    ,       
		        AbilityCash    . ,
		              
		       ,   AbilityCash.      
		     ,    (   )  
		      ,     :

		   -    -  ,       
		       , , "    Excel". 
			 ,   ( )     
			 SetStepDescription.

		   -   - progress bar,     
		       .     
			  SetStepPercent.

		   SetStepDescription         , 
		     .          
		   .

		   SetStepPercent        
		     ,       0  100 .

		          ,    :
		   -     CompleteExport   
		   -     PrepareForImport  .
		           ,   
		   E_UNEXPECTED. */

		virtual HRESULT STDMETHODCALLTYPE SetStepDescription (LPCWSTR stepDescriptions) = 0;
		virtual HRESULT STDMETHODCALLTYPE SetStepPercent (DWORD stepPercent) = 0;

		/* ---    ----------------------------------------------------------------

		           ReportError    
		      .

		          ReportWarning, 
		        .

		             
		           
		      ,       .

		    ReportError  ReportWarning       .
		       ,    E_FAIL   
		    /.         
		     ,      ReportError 
		     E_FAIL   .

		               
		             ReportError.  ReportError
		       ,     
		    . */

		virtual void STDMETHODCALLTYPE ReportError (LPCWSTR) = 0;
		virtual void STDMETHODCALLTYPE ReportWarning (LPCWSTR) = 0;

	}; // struct APluginTools

	// ---------------------------------------------------------------------------------------------
	// --- AExportImportBaseInterface --------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------
	// AExportImportBaseInterface         
	//  .
	struct AExportImportBaseInterface {

		//      .
		virtual int STDMETHODCALLTYPE GetVersion (void) = 0;

		// AbilityCash        
		// / .
		virtual void STDMETHODCALLTYPE SetToolsInterface (APluginTools *) = 0;

		//  GetPluginIID     .
		//     ,    ,
		//            .
		//           
		//    .
		virtual const GUID & STDMETHODCALLTYPE GetPluginIID (void) = 0;

		//    true,    
		//  ,  ,     ,
		//      .   
		//  false,        
		//       ,   .
		virtual bool STDMETHODCALLTYPE FileRequired (void) = 0;

		//  GetFileDescription      .  
		//     -   . , 
		//    NULL.    AbilityCash   
		//  : "  #s",  #s -  ,   GetFileType
		virtual LPCWSTR STDMETHODCALLTYPE GetFileDescription (void) = 0;

		// GetDefaultFileName ,   -    
		// .        fileName    ,
		//            .
		//       (  FileRequired  false), 
		//    .
		virtual void STDMETHODCALLTYPE GetDefaultFileName (LPWSTR fileName, UINT bufSizeInChars) = 0;

		//  ,    . ,    Excel 
		//    "xls",    xml - "xml" .
		virtual LPCWSTR STDMETHODCALLTYPE GetFileType (void) = 0;

		//   true,      
		//   false   .
		virtual bool STDMETHODCALLTYPE HasConfiguration (void) = 0;

		// ,        .
		virtual void STDMETHODCALLTYPE ConfigurePlugin (HWND parentHandle) = 0;

		// SetFileName        .
		virtual void STDMETHODCALLTYPE SetFileName (LPCWSTR) = 0;

		//  GetStreamInterface         . 
		//       .
		//             XML.
		//             XML.
		virtual HRESULT STDMETHODCALLTYPE GetStreamInterface (ASequentialStream **) = 0;

		//  Release      .   
		//     ,     , ,
		//        .   
		//      AbilityCash     
		//   Release();
		virtual void STDMETHODCALLTYPE Release (void) = 0;

	}; // struct AExportImportBaseInterface

	// ---------------------------------------------------------------------------------------------
	// --- AExportInterface ------------------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------
	//    .      .
	struct AExportInterface : AExportImportBaseInterface {

		// PrepareForExport    .     S_OK,
		//      AbilityCash      
		// ,      GetStreamInterface.
		virtual HRESULT STDMETHODCALLTYPE PrepareForExport (void) = 0;

		//  CompleteExport   ,  AbilityCash  
		//     .
		virtual HRESULT STDMETHODCALLTYPE CompleteExport (void) = 0;

	};

	// ---------------------------------------------------------------------------------------------
	// --- AImportInterface ------------------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------
	//    .       .
	struct AImportInterface : AExportImportBaseInterface {

		// PrepareForImport    .     
		// GetStreamInterface      .  PrepareForImport
		//  S_OK,    AbilityCash    
		//  .
		virtual HRESULT STDMETHODCALLTYPE PrepareForImport (void) = 0;

		//     ,      
		//  AbilityCash.
		virtual HRESULT STDMETHODCALLTYPE ImportCompleted (void) = 0;
	};

};

typedef ExportImport::AExportInterface * LPEXPORTINTERFACE;
extern "C" DWORD STDMETHODCALLTYPE GetExportInterfaceCount (void);
extern "C" LPEXPORTINTERFACE STDMETHODCALLTYPE GetExportInterface (DWORD index);

typedef ExportImport::AImportInterface * LPIMPORTINTERFACE;
extern "C" DWORD STDMETHODCALLTYPE GetImportInterfaceCount (void);
extern "C" LPIMPORTINTERFACE STDMETHODCALLTYPE GetImportInterface (DWORD index);

#endif // ABILITYCASH_EXPORT_AND_IMPORT_INTERFACES_HEADER
